package com.agilex.healthcare.mobilehealthplatform.adr;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSupplementalDemographicsDataLayerAdr;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.system.health.SmokeTest;
import com.agilex.system.health.SmokeTestStatus;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class AdrSoapLearningTest {

    AdrConfiguration adrConfiguration;
    PatientSupplementalDemographicsDataLayerAdr dataLayer;

	@Before
	public void setUp() {
		// https://vaww.server1234.aac.domain:8430/esr-ws/spring-ws/getEESummary/
		// -- don't have specific access to this
		// https://vaww.server1234.aac.domain:8443/esr-ws/spring-ws/getEESummary/
        adrConfiguration = new AdrConfiguration("http://172.16.45.55:8089/adr/mockeeSummaryPortSoap11?WSDL", "http://172.16.45.55:8089/adr/mockeeSummaryPortSoap11", "mobileHealthRequest", "mobileHealthAcct", "mhaReq$29", 5000, 30000);
//		adrConfiguration = new AdrConfiguration("http://localhost:8080/adr/mockeeSummaryPortSoap11?WSDL", "http://localhost:8080/adr/mockeeSummaryPortSoap11", "mobileHealthRequest", "mobileHealthAcct", "mhaReq$29", 5000, 30000);

        dataLayer = new PatientSupplementalDemographicsDataLayerAdr(adrConfiguration);
    }

	@Test
	public void validateConnectivity() {
		PatientDemographics supplementalDemographics = dataLayer.fetchDemographics(new PatientIdentifier("ICN", "1011215990V998459"));
		
		// Fairly generic to allow us to change the ICN without causing the test to fail.
		assertNotNull(supplementalDemographics);
		assertNotNull(supplementalDemographics.getAddresses());
		assertTrue(supplementalDemographics.getAddresses().size() >= 1);
		assertNotNull(supplementalDemographics.getPhoneNumbers());
		assertTrue(supplementalDemographics.getPhoneNumbers().size() >= 1);
		assertNotNull(supplementalDemographics.getNextOfKin());
	}

    @Test
    public void smokeTestSuccess() {
        SmokeTest test = dataLayer;
        SmokeTestStatus status = test.run();


        assertTrue(status.isSuccess());
    }

    @Test
    public void smokeTestFailure() {
        adrConfiguration = new AdrConfiguration("https://www.google.com/esr-ws/spring-ws/eeSummary.wsdl", "https://www.google.com:8443/esr-ws/spring-ws/getEESummary/", "invalidRequest", "mobileHealthAcct", "mhaReq$29", 3000, 10000);
        SmokeTest test = new PatientSupplementalDemographicsDataLayerAdr(adrConfiguration);
        SmokeTestStatus status = test.run();

        assertFalse(status.isSuccess());
        assertEquals("java.net.SocketTimeoutException", status.getExceptionType());
    }

}